using Code6587EN.Ch07.Controls;

namespace Code6587EN.Ch07.Features.Code6587EN.Ch07
{

    using Microsoft.SharePoint;
    using Microsoft.SharePoint.Administration;
    using System;
    using System.Collections.ObjectModel;
    using System.Runtime.InteropServices;

    /// <summary>
    /// This class handles events raised during feature activation, deactivation, installation, uninstallation, and upgrade.
    /// </summary>
    /// <remarks>
    /// The GUID attached to this class may be used during packaging and should not be modified.
    /// </remarks>

    [Guid("8ba70fa8-2125-4249-9b15-ae93013748a3")]
    public class Code6587ENEventReceiver : SPFeatureReceiver
    {
        // Override the FeatureActivated method
        public override void FeatureActivated(SPFeatureReceiverProperties properties)
        {
            // Since we are writing to the web.config for the current web application, 
            // run the code as the service account.
            SPSecurity.RunWithElevatedPrivileges(() =>
                {
                    // Get the Content Web Service
                    SPWebService service = SPWebService.ContentService;

                    // Create a new web.config modification record
                    SPWebConfigModification myModification = new SPWebConfigModification();

                    // Provide the XML path to the site map providers section
                    myModification.Path = "configuration/system.web/siteMap/providers";

                    // Provide the details for the new site map provider
                    myModification.Name = "add[@name='CustomSiteMapProvider']";
                    myModification.Sequence = 0;
                    myModification.Owner = "Code6587ENCustomSiteMapProvider";
                    myModification.Type = SPWebConfigModification.SPWebConfigModificationType.EnsureChildNode;
                    var typeName = typeof(CustomSiteMapProvider).FullName + ", " + typeof(CustomSiteMapProvider).Assembly.FullName;
                    myModification.Value = "<add name=\"CustomSiteMapProvider\" type=\"" + typeName + "\" NavigationType=\"Global\" />";

                    // Add the modification to the collection of modifications
                    service.WebConfigModifications.Add(myModification);

                    // Update and apply the modification
                    service.Update();
                    service.ApplyWebConfigModifications();
                });
        }

        // Override the FeatureDeactivated method
        public override void FeatureDeactivating(SPFeatureReceiverProperties properties)
        {
            // Since we are writing to the web.config for the current web application, 
            // run the code as the service account.
            SPSecurity.RunWithElevatedPrivileges(() =>
                {
                    // Get the Content Web Service
                    SPWebService service = SPWebService.ContentService;

                    // Get the collection of current modifications
                    Collection<SPWebConfigModification> modsCollection = service.WebConfigModifications;

                    int modsCount1 = modsCollection.Count;
                    for (int i = modsCount1 - 1; i > -1; i--)
                    {
                        // Remove any modifications that match our custom owner record
                        if (modsCollection[i].Owner.Equals("Code6587ENCustomSiteMapProvider"))
                        {
                            modsCollection.Remove(modsCollection[i]);
                        }
                    }

                    // Update and apply the modification changes
                    service.Update();
                    service.ApplyWebConfigModifications();
                });
        }
    }
}
